<?php

/**
 * Template name: Test
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package lifescore
 */

get_header();

// print_r($_REQUEST);
?>
<div class="main_contant">
    <!------about_mylife-------->
    <section class="membership_life">
        <div class="row">
            <div class="col-sm-12">
                <div class="membership-heading">
                    <h2> <?php the_title(); ?> </h2>
                </div>
            </div>
        </div>
    </section>
    <section class="bg-light my-5">
        <div class="container">
            <div class="row">
                <!-- cart -->
                <div class="col-lg-9 mt-3 mb-3">
                    <div class="card border shadow-0">
                        <div class="m-4">
                            <h4 class="card-title mb-4">Your shopping cart</h4>
                            <?php
                            defined('ABSPATH') || exit;
                            wc_print_notices();
                            do_action('woocommerce_before_cart');
                            ?>
                            <form action="<?php echo esc_url(wc_get_cart_url()); ?>" method="post">
                                <?php
                                do_action('woocommerce_before_cart_contents');

                                foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
                                    $_product = $cart_item['data'];
                                    $product_id = $cart_item['product_id'];

                                    if ($_product && $_product->exists() && $cart_item['quantity'] > 0) {
                                        $product_permalink = $_product->is_visible() ? $_product->get_permalink($cart_item) : '';
                                ?>

                                        <div class="row gy-3 mb-4">
                                            <div class="col-lg-4">
                                                <div class="me-lg-5">
                                                    <div class="d-flex">
                                                        <!-- <img src="https://bootstrap-ecommerce.com/bootstrap5-ecommerce/images/items/11.webp" class="border rounded me-3" style="width: 96px; height: 96px;" />
                                                        <div class="">
                                                            <a href="#" class="nav-link">Winter jacket for men and lady</a>
                                                            <p class="text-muted">Yellow, Jeans</p>
                                                        </div> -->
                                                        <?php
                                                        $thumbnail = apply_filters('woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key);

                                                        if (!$product_permalink) {
                                                            echo $thumbnail; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                                                        } else {
                                                            printf('<a href="%s">%s</a>', esc_url($product_permalink), $thumbnail); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                                                        }
                                                        ?>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-2 col-sm-6 col-12 d-flex flex-row flex-lg-column flex-xl-row text-nowrap">
                                                <div class="">
                                                    <?php
                                                    if (!$product_permalink) {
                                                        echo apply_filters('woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                                                    } else {
                                                        printf('<a href="%s">%s</a>', esc_url($product_permalink), apply_filters('woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key)); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                                                    }

                                                    do_action('woocommerce_after_cart_item_name', $cart_item, $cart_item_key);

                                                    // Meta data.
                                                    echo wc_get_formatted_cart_item_data($cart_item); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

                                                    // Backorder notification.
                                                    if ($_product->backorders_require_notification() && $_product->is_on_backorder($cart_item['quantity'])) {
                                                        echo '<p class="backorder_notification">' . esc_html__('Available on backorder', 'woocommerce') . '</p>';
                                                    }
                                                    ?>
                                                    <!-- <text class="h6">$1156.00</text> <br /> -->
                                                    <!-- <small class="text-muted text-nowrap"> $460.00 / per item </small> -->
                                                </div>
                                            </div>
                                            <div class="col-lg-2 col-sm-6 col-12 d-flex flex-row flex-lg-column flex-xl-row text-nowrap">
                                                <div class="">
                                                    <?php
                                                    echo apply_filters('woocommerce_cart_item_price', WC()->cart->get_product_price($_product), $cart_item, $cart_item_key); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                                                    ?>
                                                    <!-- <text class="h6">$1156.00</text> <br /> -->
                                                    <!-- <small class="text-muted text-nowrap"> $460.00 / per item </small> -->
                                                </div>
                                            </div>
                                            <div class="col-lg-2 col-sm-6 col-12 d-flex flex-row flex-lg-column flex-xl-row text-nowrap">
                                                <div class="">
                                                    <?php
                                                    echo apply_filters('woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal($_product, $cart_item['quantity']), $cart_item, $cart_item_key); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                                                    ?>
                                                </div>
                                            </div>
                                            <div class="col-lg-2 col-sm-6 col-12 d-flex justify-content-sm-center justify-content-md-start justify-content-lg-center justify-content-xl-end mb-2">
                                                <div class="float-md-end">
                                                    <?php
                                                    echo apply_filters('woocommerce_cart_item_remove_link', sprintf(
                                                        '<a href="%s" class="remove btn btn-light border text-danger icon-hover-danger" aria-label="%s" data-product_id="%s" data-product_sku="%s">Remove</a>',
                                                        esc_url(wc_get_cart_remove_url($cart_item_key)),
                                                        esc_html__('Remove this item', 'woocommerce'),
                                                        esc_attr($product_id),
                                                        esc_attr($_product->get_sku())
                                                    ), $cart_item_key);
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                <?php
                                    }
                                }

                                do_action('woocommerce_cart_contents');
                                ?>
                            </form>
                        </div>
                    </div>
                </div>
                <!-- cart -->
                <!-- summary -->
                <div class="col-lg-3 mt-3 mb-3">
<!--                     <div class="card mb-3 border shadow-0"> -->
<!--                         <div class="card-body"> -->
<!--                             <form action="<?php echo esc_url(wc_get_cart_url()); ?>" method="post"> -->
                                <!-- Existing Cart contents -->

                                <!-- <div class="coupon-form">
                                    <label for="coupon_code"><?php esc_html_e('Enter Coupon Code:', 'woocommerce'); ?></label>
                                    <input type="text" name="coupon_code" id="coupon_code" placeholder="<?php esc_attr_e('Coupon Code', 'woocommerce'); ?>" />

                                    <button type="submit" name="apply_coupon" class="button"><?php esc_html_e('Apply Coupon', 'woocommerce'); ?></button>
                                </div> -->
<!--                                 <div class="form-group coupon-form">
                                    <label class="form-label coupon_code"><?php esc_html_e('Enter Coupon Code:', 'woocommerce'); ?></label>
                                    <div class="input-group"> -->
                                        <!-- <input type="text" class="form-control border" name="" placeholder="Coupon code" /> -->
                                        <!-- <button class="btn btn-light border">Apply</button> -->
<!--                                         <input type="text" name="coupon_code" id="coupon_code" class="form-control" placeholder="<?php esc_attr_e('Coupon Code', 'woocommerce'); ?>" /> -->

<!--                                         <button type="submit" name="apply_coupon button btn btn-success" class="button"><?php esc_html_e('&nbsp; Apply Coupon &nbsp;', 'woocommerce'); ?></button> -->
<!--                                     </div> -->
<!--                                 </div> -->
                                <!-- Nonce for security -->
<!--                             </form> -->
                            <!-- <form> -->
                            <!-- </form> -->
<!--                         </div> -->
<!--                     </div> -->
                    <div class="card shadow-0 border">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <p class="mb-2">Total price:</p>
                                <p class="mb-2"><?php echo $cart_subtotal = WC()->cart->get_cart_subtotal(); ?></p>
                            </div>
                            <div class="d-flex justify-content-between">
                                <p class="mb-2">Discount:</p>
                                <p class="mb-2 text-success">
                                    <?php
                                    if (class_exists('WooCommerce') && WC()->cart) {
                                        // Get the total discount in the cart
                                        $cart_discount_total = WC()->cart->get_cart_discount_total();

                                        // Display the total discount
                                        echo '£' . $cart_discount_total;
                                    } else {
                                        echo 'WooCommerce is not initialized or the cart is empty.';
                                    }
                                    ?>
                                </p>
                            </div>
                            <!-- <div class="d-flex justify-content-between">
                                <p class="mb-2">TAX:</p>
                                <p class="mb-2">$14.00</p>
                            </div> -->
                            <hr />
                            <div class="d-flex justify-content-between">
                                <p class="mb-2">Total price:</p>
                                <p class="mb-2 fw-bold"><?php echo $cart_total = WC()->cart->get_total(); ?></p>
                            </div>

                            <div class="mt-3">
                                <?php $checkout_url = wc_get_checkout_url(); ?>
                                <a href="<?php echo esc_url($checkout_url); ?>" class="button proceed-to-checkout btn btn-success w-100 shadow-0 mb-2">
                                    <?php esc_html_e('Proceed to Checkout', 'woocommerce'); ?>
                                </a>
                                <!-- <a href="#" class="btn btn-success w-100 shadow-0 mb-2"> Make Purchase </a> -->
                                <!-- <a href="#" class="btn btn-light w-100 border mt-2"> Back to shop </a> -->
                            </div>
                        </div>
                    </div>
                </div>
                <!-- summary -->
            </div>
        </div>
    </section>
</div><!-----main_contant-------->
<?php
get_footer();
